<!DOCTYPE html>
<html lang="en"><head>
<!--[if IE]><![endif]--><!-- IE9 performance fix -->
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<!-- Created: 2015-06-24 -->
<title>Login - Riccochet Network</title>
<style type="text/css">
html, body {
	background: #4c4c4c;
	color: #bbb;
	margin: 0;
	padding: 0;
	height: 100%;
}
#pageWrapper {
	height: 100%;
	text-align: center;
}

body,table,td,th,textarea,input,button {
	font-family: "Raleway","Helvetica Neue",
		Helvetica,Frutiger,"Frutiger Linotype",Univers,"Gill Sans","Myriad Pro",
		Myriad,"DejaVu Sans","Liberation Sans","Nimbus Sans L",Tahoma,sans-serif;
	font-size: 1em;
}
body {
	font-size: 112.5%;
	line-height: 1.5;
	font-weight: 400;
}

body.login form {
	padding: 5em 0;
	display: inline-block;
	vertical-align: middle;
	width: 18em;
	max-width: 98%;
	margin: 0 auto;
}
#pageWrapper:after {
	content: '\a0';
	width: 1px;
	margin-left: -.3em;
	display: inline-block;
	vertical-align: middle;
	height: 100%;
}
@media all and (max-height:30em) {
	body.login form {
		padding: 1em 0;
		
	}
}
a img {
	border: 0 none;
}
#logo {
	width: 55px;
	margin: 0 auto 1em;
	position: relative;
}
#logo img,
#logo object {
	width: 55px;
	height: 85px;
}
#logo .link {
	position: absolute;
	top: 0;
	left: 0;
	width: 100%;
	max-height: none;
	z-index: 9;
}


textarea,input,select, .button {
	-webkit-box-sizing: border-box;
	-moz-box-sizing: border-box;
	box-sizing: border-box;
}
button.button::-moz-focus-inner {padding:0;border:none}

input::-webkit-input-placeholder {color: #E8E8E8}
input:-moz-placeholder {color: #E8E8E8}
input::-moz-placeholder {color: #E8E8E8; opacity:1}
input:-ms-input-placeholder {color: #E8E8E8}
input.placeholder {color: #E8E8E8}

.transforms-supported body.login input:-ms-input-placeholder {color: transparent}
.transforms-supported body.login input::-webkit-input-placeholder,
input:focus::-webkit-input-placeholder {color: transparent}
.transforms-supported body.login input:-moz-placeholder,
input:focus:-moz-placeholder {color: transparent}
.transforms-supported body.login input::-moz-placeholder,
input:focus::-moz-placeholder {color: transparent}

.field, .buttons {
	padding: .5em 0;
	position: relative;
}
.field input {
	width: 18em;
	max-width: 100%;
	-moz-border-radius: 6px;
	-webkit-border-radius: 6px;
	border-radius: 6px;
	border: 0 none;
	background: #656565;
	color: #fff;
	padding: .25em .5em;
}

.field label {
	display: block;
	padding-right: .5em;
	text-align: left;
	-webkit-font-smoothing: antialiased;
}
@media all and (min-width:660px){
	.field label {
		display: inline-block;
		position: absolute;
		top: .625em;
		right: 100%;
		white-space: nowrap;
	}
	.transforms-supported .field label {
		top: .625em;
		left: 0;
		right: auto;
		padding-right: .5em;
		-webkit-transform: translateX(-100%);
		-moz-transform: translateX(-100%);
		transform: translateX(-100%);
		-webkit-transform: translate3d(-100%,0,0);
		-moz-transform: translate3d(-100%,0,0);
		transform: translate3d(-100%,0,0);
	}
	.transforms-supported .field.overlap label {
		-webkit-transform: translateX(.5em);
		-moz-transform: translateX(.5em);
		transform: translateX(.5em);
		-webkit-transform: translate3d(.5em,0,0);
		-moz-transform: translate3d(.5em,0,0);
		transform: translate3d(.5em,0,0);
	}
}


.button {
	display: inline-block;
	color: #fff;
	background: #334b99 none;
	-webkit-transition: background .5s, opacity .5s, color .5s;
	-moz-transition: background .5s, opacity .5s, color .5s;
	transition: background .5s, opacity .5s, color .5s;
	-webkit-border-radius: 3px;
	-moz-border-radius: 3px;
	border-radius: 3px;
	padding: 8px 12px;
	padding: 6px 12px;
	border: 0 none;
	text-transform: uppercase;
	text-decoration: none;
	text-align: center;
	line-height: 1.6;
	min-width: 11.5em;
	font-size: 1em;
	font-weight: 400;
}
body.login .button {
	max-width: 100%;
	width: 100%;
	background: #ff9000;
	/*
	color: #333;
	-moz-border-radius: 6px;
	-webkit-border-radius: 6px;
	border-radius: 6px;*/
}
body.login .button:hover,
body.login .button:focus,
body.login .button:active {
	background-color: #ff4200;
}

body.login p.forgot {
	margin: .25em 0 0;
}
body.login .forgot a {
	color: #999;
	font-size: .8em;
	text-decoration: none;
}
body.login .forgot a:hover,
body.login .forgot a:focus,
body.login .forgot a:active {
	text-decoration: underline;
}

body.login form {
	position: relative;
}
body.login label,
body.login form>*,
body.login .formContent>* {
	-webkit-transition: -webkit-transform .5s ease, opacity .5s ease;
	-moz-transition: -moz-transform .5s ease, opacity .5s ease;
	transition: transform .5s ease, opacity .5s ease;
	-webkit-backface-visibility: hidden;
	-moz-backface-visibility: hidden;
}
body.login label.noTT {
	-webkit-transition: -webkit-transform 0s;
	-moz-transition: -moz-transform 0s;
	transition: transform 0s;
}
body.login form .slideUp {
	-webkit-transition: -webkit-transform 0s, opacity 0s;
	-moz-transition: -moz-transform 0s, opacity 0s;
	transition: transform 0s, opacity 0s;
	-webkit-transform: translateY(4em);
	-moz-transform: translateY(4em);
	transform: translateY(4em);
	-webkit-transform: translate3d(0,54px,0);
	-moz-transform: translate3d(0,54px,0);
	transform: translate3d(0,54px,0);
	opacity: .25;
}
</style>
<link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css">
<link href='http://fonts.googleapis.com/css?family=Raleway:400,300,100,700' rel='stylesheet' type='text/css'>
</head>
<body class="login">

<div id="pageWrapper">

	<form method="post" action="https://secure.ricochetnetwork.com/dologin.php">
		<div id="logo">
			<img src="https://d2aeiyufnrlqzi.cloudfront.net/clear.gif" class="link" alt="Ricochet">
			<!--[if (!IE)|(gt IE 8)]><!-->
			<object data="https://d2aeiyufnrlqzi.cloudfront.net/ricochet-logo-only.svg" type="image/svg+xml" tabindex="-1"><img src="https://d2aeiyufnrlqzi.cloudfront.net/ricochet-logo-only.png" alt="Ricochet Login"></object>
			<!--<![endif]-->
			<!--[if lt IE 9]><img src="assets/images/ricochet-logo-only.png" alt=""><![endif]-->
		</div> <!-- /#logo -->
		<div class="field">
			<label for="username">Email Address</label> <input type="email" name="username" id="username" placeholder="Email Address" size="40">
		</div> <!-- /.field -->
		<div class="field">
			<label for="password">Password</label> <input type="password" name="password" id="password" placeholder="Password" size="40">
		</div> <!-- /.field -->
		<div class="buttons"><button type="submit" class="button">Login</button></div> <!-- /.buttons -->
		<p class="forgot"><a href="https://secure.ricochetnetwork.com/pwreset.php">Forgotten your password?</a></p>
	</form>

</div> <!-- /#pageWrapper -->


<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
<script type="text/javascript">if(typeof jQuery=='undefined') document.write(unescape(
"%3Cscript src='assets/js/jquery-1.11.3.min.js' type='text/javascript'%3E%3C/script%3E"));</script>

<script type="text/javascript">
window.requestAnimFrame = (function(undef){
	return window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || undef;
})();
function has3d(test2d) { // by Lorenzo Polidori
	var d=document, // https://gist.github.com/lorenzopolidori/3794226
		el=d.createElement('p'),
		b=d.body;
		has3d,
		transforms={
			'webkitTransform':'-webkit-',
			'OTransform':'-o-',
			'msTransform':'-ms-',
			'MozTransform':'-moz-',
			'transform':''
		};
	// Add it to the body to get the computed style.
	b.insertBefore(el,null);
	for(var t in transforms) {
		if(el.style[t]!==undefined) {
			if(!test2d) el.style[t]="translate3d(1px,1px,1px)";
			else el.style[t]="translate(1px,1px)";
			has3d=window.getComputedStyle(el).getPropertyValue(transforms[t]+'transform');
		}
	}
	b.removeChild(el);
	return (has3d!==undefined && has3d.length>0 && has3d!=="none");
}
jQuery(document).ready(function($){
	$('html').addClass('jsOn');

	var isMSIE=/*@cc_on!@*/false; // http://dean.edwards.name/weblog/2007/03/sniff/
	isMSIE=isMSIE||window.navigator.msPointerEnabled;
	var IEpre10=(isMSIE&&((typeof document.documentMode=='undefined')||document.documentMode<10));

	if(has3d(true) && !IEpre10 && window.requestAnimFrame) {
		$('html').addClass('transforms-supported');
		$('form').children().not('#logo').addClass('slideUp');

		if(isMSIE&&(document.documentMode===10)) {
			$('.field input').on('change',function(){
				var el=this;
				el.value=' '+el.value;
				setTimeout(function(){el.value=el.value.slice(1)},9);
			});
		}

		$('.field').addClass('overlap').find('input').on('focus',function(e){
			$(e.target.parentNode).removeClass('overlap');
		}).on('keyup blur',function(e){
			if(e.type.indexOf('keyup')!=-1 && (((e.keyCode||e.which)==9)||(e.keyCode||e.which)==16))
				return;
			var el=e.target;
			if(el.value.length>0) $(el.parentNode).removeClass('overlap');
			else $(el.parentNode).addClass('overlap');
		}).each(function(){
			if(this.value.length>0) {
				var el=this.parentNode;
				$(el).find('label').addClass('noTT')
					.end().removeClass('overlap');
				setTimeout(function(){
					$('label',el).removeClass('noTT');
				},500);
			}
		});

		$(window).on('load',function(){
			var oneByOne=0;
			var $elms=$('form').children(),
			callback=function(){
				$($elms[oneByOne]).removeClass('slideUp');
				oneByOne++;
				if(oneByOne<$elms.length) requestAnimFrame(callback);
			};
			callback();
		});
	}
});
</script>

</body>
</html>
