document.createElement('picture');
document.createElement('source');

var jqFn=jqFn||{};
// debouncing function from John Hann
// http://unscriptable.com/index.php/2009/03/20/debouncing-javascript-methods/
jqFn.debounce=function(func,threshold,execAsap){
	var timeout;
	return function debounced(){
		var obj=this,args=arguments;
		function delayed(){
			if(!execAsap) func.apply(obj, args);
			timeout=null;
		};
		if(timeout) clearTimeout(timeout);
		else if(execAsap) func.apply(obj,args);
		timeout=setTimeout(delayed,threshold||100);
	};
};
(function($,sr){
	// http://www.paulirish.com/2009/throttled-smartresize-jquery-event-handler/
	// *** debounce function moved out so it can be used for other things ***
	// smartresize
	$.fn[sr] = function(fn){ return fn ? this.on('resize', jqFn.debounce(fn)) : this.trigger(sr); };

})(jQuery,'smartresize');

function throttle(fn, threshhold, scope) {
	// http://remysharp.com/2010/07/21/throttling-function-calls/
	threshhold || (threshhold=250);
	var last, deferTimer;
	return function(){
		var context=scope||this, now= +new Date, args=arguments;
		if(last && now < last + threshhold) {
			// hold on to it
			clearTimeout(deferTimer);
			deferTimer=setTimeout(function(){
				last=now;
				fn.apply(context, args);
			}, threshhold);
		} else {
			last=now;
			fn.apply(context, args);
		}
	};
}

/* https://github.com/paulirish/matchMedia.js */
/*! matchMedia() polyfill - Test a CSS media type/query in JS. Authors & copyright (c) 2012: Scott Jehl, Paul Irish, Nicholas Zakas, David Knight. Dual MIT/BSD license */
window.matchMedia || (window.matchMedia=function() {
	"use strict";

	// For browsers that support matchMedium api such as IE 9 and webkit
	var styleMedia=(window.styleMedia || window.media);

	// For those that don't support matchMedium
	if(!styleMedia) {
		var style=document.createElement('style'),
			script=document.getElementsByTagName('script')[0],
			info=null;

		style.type='text/css';
		style.id='matchmediajs-test';
		script.parentNode.insertBefore(style, script);

		// 'style.currentStyle' is used by IE <=8 and 'window.getComputedStyle' for all other browsers
		info=('getComputedStyle' in window) && window.getComputedStyle(style, null) || style.currentStyle;

		styleMedia={
			matchMedium: function(media) {
				var text='@media ' + media + '{ #matchmediajs-test { width: 1px; } }';

				// 'style.styleSheet' is used by IE <=8 and 'style.textContent' for all other browsers
				if(style.styleSheet) {
					style.styleSheet.cssText=text;
				} else {
					style.textContent=text;
				}
				// Test if media query is true or false
				return info.width==='1px';
			}
		};
	}
	return function(media) {
		return {
			matches: styleMedia.matchMedium(media || 'all'),
			media: media || 'all'
		};
	};
}());

function has3d(test2d) { // by Lorenzo Polidori
	var d=document, // https://gist.github.com/lorenzopolidori/3794226
		el=d.createElement('p'),
		b=d.body;
		has3d,
		transforms={
			'webkitTransform':'-webkit-',
			'OTransform':'-o-',
			'msTransform':'-ms-',
			'MozTransform':'-moz-',
			'transform':''
		};
	// Add it to the body to get the computed style.
	b.insertBefore(el,null);
	for(var t in transforms) {
		if(el.style[t]!==undefined) {
			if(!test2d) el.style[t]="translate3d(1px,1px,1px)";
			else el.style[t]="translate(1px,1px)";
			has3d=window.getComputedStyle(el).getPropertyValue(transforms[t]+'transform');
		}
	}
	b.removeChild(el);
	return (has3d!==undefined && has3d.length>0 && has3d!=="none");
}

window.requestAnimFrame = (function(undef){
	return window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || undef;
})();
window.cancelAnimFrame = (function(undef){
	return window.cancelAnimationFrame || window.webkitCancelAnimationFrame || window.mozCancelAnimationFrame || undef;
})();

jQuery(document).ready(function($){
	$('html').addClass('jsOn');

	var isMSIE=/*@cc_on!@*/false; // http://dean.edwards.name/weblog/2007/03/sniff/
	isMSIE=isMSIE||window.navigator.msPointerEnabled;
	var IEpre8=(isMSIE&&((typeof document.documentMode=='undefined')||document.documentMode<8));
	var IEpre9=(isMSIE&&((typeof document.documentMode=='undefined')||document.documentMode<9));
	var IEpre10=(isMSIE&&(IEpre9||document.documentMode<10));

	var touchSupport=('ontouchstart' in window) || (navigator.maxTouchPoints>0) || (navigator.msMaxTouchPoints>0);

	var initMobileMenu=function(){
		if(!initMobileMenu.hasRun) {
			$('#headNav').hide().css({top:+$('#headerWrapper').height()+'px'});
			$('.mobileMenuBtn,#headerWrapper').removeClass('mobileMenuOpen');
			if(has3d(true) && !IEpre10) $('html').addClass('transforms-supported');
		}
		if(initMobileMenu.hasRun) {
			$('ul,.dropdown','#header .nav li').hide();
		} else {
			if($('#header a.mobileMenuBtn object').length)
				$('#header a.mobileMenuBtn object').append('<i class="fa fa-times"></a>');
			else
				$('#header a.mobileMenuBtn').append('<i class="fa fa-times"></a>');
			var pageScrollTop=0,pageScrollElm;
			$('#header a.mobileMenuBtn').click(function(e){
				$m=$('#headNav');

				var dE=document.documentElement;
				if(!$('#headerWrapper').hasClass('mobileMenuOpen') || !$m.is(':visible')) {
					if(dE && dE.scrollTop>=0 && document.body.scrollTop==0)
						pageScrollElm=dE;
					else
						pageScrollElm=document.body;
					pageScrollTop=pageScrollElm.scrollTop;
					$m.css({
						display:'block',
						top:$('#headerWrapper').height()+'px'
					});
					$('.mobileMenuOverlay').css({top:0,height:$('#headerWrapper').height()+'px'});


					var vW=$(window).width(),
						vH=$(window).height()-($('#headerWrapper').height()),
						diffH=0,
						divisor=25,
						maxT=20;
					if(window.matchMedia && !IEpre9 && $(window).height()<600 && window.matchMedia('all and (orientation:landscape)').matches) {
						vH=$(window).height();
						$m.css({top:0});
					}
					$m.find('ul.nav').css({
						'font-size':'1.75em',
						'-webkit-text-size-adjust':'none',
						'-moz-text-size-adjust':'none',
						'-ms-text-size-adjust':'none'
					});
					diffH=vH-$m.get(0).clientHeight-40;
					if(diffH>500) diffH=500;
					if(diffH>0) {
						$m.find('ul.nav').css('font-size',(2*Math.abs(1+(diffH/divisor)))+'em');
						while($m.get(0).clientHeight>vH && maxT-->0) {
							divisor+=40;
							$m.find('ul.nav').css('font-size',(2*Math.abs(1+(diffH/divisor)))+'em');
						}
					} else {
						diffH=Math.abs(vH-$m.get(0).clientHeight)*-1;
						if(diffH>-1) diffH=-1;
						maxT=30;
						divisor=4;
						$m.find('ul.nav').css({
							'font-size':(2*Math.abs(1+(diffH/divisor)))+'em'
						});
						while($m.get(0).clientHeight>vH && maxT-->0) {
							if(maxT==10) divisor+=10;
							else if(maxT<7 && maxT>0 && maxT%2==0) divisor+=20;
							divisor+=2;
							$m.find('ul.nav').css('font-size',(2*Math.abs(1+(diffH/divisor)))+'em');
						}
					}

					$(pageScrollElm).css({overflow:'hidden'});
					$('.mobileMenuBtn,#headerWrapper').addClass('mobileMenuOpen');
					$(document).on('touchmove.mainNav',function(e){ e.preventDefault()});
				} else {
					pageScrollElm.scrollTop=pageScrollTop;
					$('#headerWrapper').addClass('mobileMenuClosing');
					setTimeout(function(){
						$('html,body').css({overflow:''});
						$('.mobileMenuBtn,#headerWrapper').removeClass('mobileMenuOpen mobileMenuClosing');
					},550);
					$(document).off('touchmove.mainNav');
				}
				return false;
			});
			$('#headerWrapper').append('<div class="mobileMenuOverlay"></div>');
			initMobileMenu.hasRun=true;
		}
	}
	initMobileMenu();
	$(window).on('orientationchange',initMobileMenu);
	$(window).smartresize(initMobileMenu);

	// for Firefox Mobile
	if(window.matchMedia) 
		window.matchMedia("(orientation:portrait)").onchange=initMobileMenu;


	$('#header').addClass('loaded');


	if($('body').hasClass('home')) {
		if($(window).width()>320 && !IEpre8) {
			$('.headerBar').addClass('fixed aboveTop');
			if($(window).width()>=700 && $(window).height()>400) $('.headerBar').show();
			if($(window).width()>540 && $(window).height()>540) {
				$('.featuresWrap,.controlpanelWrap').addClass('slideUp');
				$('body.home .mainSpecs li').addClass('slideHorz');
			}
			var stickyPosB=function(){
				var sensitivity=61,
					d=document,dE=d.documentElement,s=dE.scrollTop||d.body.scrollTop,y;
	
				if(stickyPosB.changed && s<=stickyPosB.pos && s>24) return;
				var hw=$('.headerBar');
				if(s<($('.hero.contentWrap').outerHeight()-hw.outerHeight()*1.5)) {
					if(!hw.hasClass('aboveTop')) {
						hw.addClass('aboveTop').css({marginTop:'-'+hw.outerHeight()+'px'});
					}
					stickyPosB.changed=true;
				} else if(hw.hasClass('aboveTop') && Math.abs(stickyPosB.pos2-s)>sensitivity) {
					hw.css({marginTop:0});
					setTimeout(function(){
						hw.removeClass('aboveTop');
					},500);
					stickyPosB.changed=true;
				}
				
				if($(window).width()<700 || $(window).height()<400) $('.headerBar').hide();

				if(typeof(self.innerHeight)=='number'){ // all except IE
					y=self.innerHeight;
				} else {
					if((!dE || !dE.clientHeight) && d.body) dE=d.body;
					y=(dE && dE.clientHeight)?dE.clientHeight:0;
				}
				var $specs=$('#specs h2'),$feat=$('#features h2'),
					$sup=$('#controlpanel h2'),visB=s+(y*.34);
				if($specs.offset().top<visB) {
					$('body.home .mainSpecs li').removeClass('slideHorz');
				}
				if($feat.offset().top<visB) {
					$('.featuresWrap').removeClass('slideUp');
				}
				if($sup.offset().top<visB) {
					$('.controlpanelWrap').removeClass('slideUp');
				}
	
				stickyPosB.pos=dE.scrollTop||d.body.scrollTop||0;
				if(stickyPosB.changed || Math.abs(stickyPosB.pos2-s)>sensitivity)
					stickyPosB.pos2=stickyPosB.pos;
				if(stickyPosB.changed) setTimeout(function(){
					stickyPosB.changed=false;
				},500);
			};
			stickyPosB.pos=document.documentElement.scrollTop||document.body.scrollTop||0;
			stickyPosB.pos2=stickyPosB.pos;
			stickyPosB.changed=false;
			stickyPosB();
			$(window).on('scroll.stickyPosB',stickyPosB);
		} else if(IEpre8) {
			$('.headerBar').show();
		}

		if($(window).width()>=720 && !IEpre9) {
      var sparkleActive=true,
        sparkleTimer;
			if(typeof(requestAnimFrame)=='undefined') return; 
			cancelAnimFrame(sparkleTimer);
			var speedT=11500,
        sparkleAnimAr=[],startTime=null,sparkleAnim=function(time){
				time=(time===undefined)?new Date().getTime():time;
				if(startTime === null) startTime=time;
				for(var i=0,j=sparkleAnimAr.length,k=0,endVal,startVal,nv,str='';i<j;i++) {
          for(k=0;k<2;k++) {
						endVal=sparkleAnimAr[i][2+k*2];
						startVal=sparkleAnimAr[i][3+k*2];

						if(endVal>startVal) {
							nv=Math.floor((time - startTime)/speedT * (endVal-startVal));
						} else {
							nv=Math.ceil((time - startTime)/speedT * (startVal-endVal)*-1);
						}
						nv+=startVal;
						if(isNaN(nv)) nv=0;
						if(speedT<(time-startTime)) nv=endVal;
            if(k==0) str=nv;
            else str+=' '+nv;
          }
					sparkleAnimAr[i][0].setAttribute(sparkleAnimAr[i][1],'translate('+str+')');
				}
				if((time-startTime)<speedT) sparkleTimer=requestAnimFrame(sparkleAnim);
				else {
          startTime=null;
          for(i=0;i<sparkleAnimAr.length;i++) {
            for(k=2;k<6;k++) {
              sparkleAnimAr[i][k]*=-1;
            } 
          }
          if(sparkleActive) sparkleTimer=requestAnimFrame(sparkleAnim);
        }
			};
			sparkleAnimAr.push(
				[document.getElementById('twinklingM').getElementsByTagName('rect')[1],'transform',100,-100,-100,100],
				[document.getElementById('twinklingM2').getElementsByTagName('rect')[1],'transform',100,-100,-100,100]
			);
			sparkleTimer=requestAnimFrame(sparkleAnim);

      $(window).on('scroll',function(){
        if(!sparkleActive) return;
        if($('html').scrollTop()>($('.hero.contentWrap').height()*.73))
          cancelAnimFrame(sparkleTimer);
        else
          sparkleTimer=requestAnimFrame(sparkleAnim);
      });
    }
		
		$('.hostingPlanInfo .priceBox').css('cursor','pointer').click(function(e){
			if(e.target.nodeName.toLowerCase()!='a') {
				var $a=$(this).closest('.priceBox').find('a');
				location.href=$a.attr('href');
			}
		});

		$('.logo,.plans,.features,.specs,.controlpanel','.headerBar').on('click','a',function(e){
			var $el=$(e.target).closest('a'),t=0,mt=0,s,d,$dest,doc=document;
			$dest=$($el.attr('href'));
			if(!$dest.length) return false;
			mt=Math.round(parseFloat($dest.css('margin-top')||0));
			t=$dest.offset().top-mt;
			if(t>=0) {
				s=(t!=0)?t:Math.max(doc.body.scrollTop,doc.documentElement?doc.documentElement.scrollTop:0);
				d=($(window).width()<570)?s/3:s/2.25;
				$('html,body').animate({scrollTop:t},d,'swing');
				if(window.history && typeof(window.history.pushState)!='undefined')
					window.history.pushState({},'',$el.attr('href'));
			}
			return false;
		});
	}

	var isHDPR=(window.devicePixelRatio>=1.5 ||
		(window.matchMedia && window.matchMedia("screen and (min-resolution:144dpi),(-webkit-min-device-pixel-ratio:1.5),(min--moz-device-pixel-ratio:1.5)").matches)
	);
	if(isHDPR){
		$('.hasHDPI,.hero .imgWrap img').each(function(){
			var that=this,isImg=(this.nodeName.toLowerCase()=='img'),tImg1,tImg2,bg,
				re=/(\.(?:png|jpg|jpeg?))\b/i,re2=/@[\d.]*\dx\./;
			if(isImg && !re2.test(this.src)){
				tImg1=new Image();
				tImg1.onload=function(){
					that.src=this.src;
					var $p=$(that).closest('.fullWidthImgInner');
					if($p.length>0) {
						$p.css({'background-image':'url('+this.src+')'});
					}
				};
				tImg1.src=this.src.replace(re,'@2x$1');
				if(!this.getAttribute('height') && !this.getAttribute('width'))
					this.setAttribute('height',this.height);
			}
			bg=$(this).css('background-image');
			if(bg!='' && !re2.test(bg)){
				tImg2=new Image();
				tImg2.onload=function(){
					that.style.backgroundImage='url("'+this.src+'")';
				};
				tImg2.src=bg.replace(/url\(['"]?([^'"]+)['"]?\)/i,'$1').replace(re,'@2x$1');
			}
		});
	}

	// placeholder attribute support script by http://www.dynamicsitesolutions.com/
	var ph='placeholder',
		clearValue=function(){
			var o=$(this);
			if(this.value===o.attr(ph)) o.val('').removeClass(ph);
		};
	// Applies placeholder attribute behavior in web browsers that don't support it
	if(!(ph in document.createElement('input'))){
		$('input['+ph+'],textarea['+ph+']').each(function(){
			var tf=$(this),v=tf.attr(ph);
			if(typeof(v)!='string' || v==='') return;
			if(tf.val()==='') tf.val(v).addClass(ph);
			tf.focus(function(){
				clearValue.call(this);
			}).blur(function(){
				if(tf.val()==='') tf.val(v).addClass(ph);
			});
		});
		// Empties the placeholder text at form submit if it hasn't changed
		$('form').submit(function(){
			$('input.'+ph+',textarea.'+ph).each(clearValue);
		});
		// Clear on window reload to avoid the values being left in the fields
		$(window).bind('beforeunload',function(){
			$('input.'+ph+',textarea.'+ph).each(clearValue);
		});
	}
});

/*! fixed-fixed - v0.1.0 - 2014-05-23
* Copyright (c) 2014 ; Licensed MIT */
/*! Fixedfixed: a CSS position:fixed qualifier. (c)2012 @scottjehl, Filament Group, Inc. Dual license: MIT and/or GPLv2 */
(function(e,t){function o(){var c="scrollTop"in e.document.body?e.document.body.scrollTop:d.scrollTop;c!==t&&c>0&&e.document.body&&(e.document.body.insertBefore(i,e.document.body.firstChild),i.getBoundingClientRect&&0===i.getBoundingClientRect().top||(d.className=d.className.replace(n,"")),e.document.body.removeChild(i),e.removeEventListener?e.removeEventListener("scroll",o,!1):e.detachEvent("onscroll",o))}var n="fixed-supported",i=e.document.createElement("div"),c=e.navigator.userAgent,d=e.document.documentElement;i.style.position="fixed",i.style.top=0,c.match(/Android 2\.[1256]/)&&c.indexOf("AppleWebKit")>-1&&c.match(/Opera Mobi\/([0-9]+)/)&&7458>RegExp.$1&&e.operamini&&"[object OperaMini]"==={}.toString.call(e.operamini)&&c.match(/Fennec\/([0-9]+)/)&&6>RegExp.$1||(d.className+=" "+n,e.addEventListener?e.addEventListener("scroll",o,!1):e.attachEvent("onscroll",o)),e.FixedFixed=o})(this);

/*! A fix for the iOS orientationchange zoom bug. Script by @scottjehl, rebound by @wilto.MIT / GPLv2 License.*/(function(a){function m(){d.setAttribute("content",g),h=!0}function n(){d.setAttribute("content",f),h=!1}function o(b){l=b.accelerationIncludingGravity,i=Math.abs(l.x),j=Math.abs(l.y),k=Math.abs(l.z),(!a.orientation||a.orientation===180)&&(i>7||(k>6&&j<8||k<8&&j>6)&&i>5)?h&&n():h||m()}var b=navigator.userAgent;if(!(/iPhone|iPad|iPod/.test(navigator.platform)&&/OS [1-5]_[0-9_]* like Mac OS X/i.test(b)&&b.indexOf("AppleWebKit")>-1))return;var c=a.document;if(!c.querySelector)return;var d=c.querySelector("meta[name=viewport]"),e=d&&d.getAttribute("content"),f=e+",maximum-scale=1",g=e+",maximum-scale=10",h=!0,i,j,k,l;if(!d)return;a.addEventListener("orientationchange",m,!1),a.addEventListener("devicemotion",o,!1)})(this);

